<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Entity Reference unique reference constraint.
 *
 * Verifies that referenced entities referenced only once.
 */
#[Constraint(
  id: 'UniqueReference',
  label: new TranslatableMarkup('Unique Entity Reference reference', [], ['context' => 'Validation'])
)]
class UniqueReferenceConstraint extends SymfonyConstraint {

  /**
   * The default violation message.
   *
   * @var string
   */
  public $message = 'A @entity_type with @field_name referencing entity with ID @id already exists.';

}
