/**
 * @file
 * Block behaviors.
 */

(function ($, window, Drupal) {
  /**
   * Provide the summary information for the block settings vertical tabs.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior for the block settings summaries.
   */
  Drupal.behaviors.crmBlockSettingsSummary = {
    attach() {
      // The drupalSetSummary method required for this behavior is not available
      // on the Blocks administration page, so we need to make sure this
      // behavior is processed only if drupalSetSummary is defined.
      if (typeof $.fn.drupalSetSummary === 'undefined') {
        return;
      }

      /**
       * Create a summary for checkboxes in the provided context.
       *
       * @param {Document|HTMLElement} context
       *   A context where one would find checkboxes to summarize.
       *
       * @return {string}
       *   A string with the summary.
       */
      function checkboxesSummary(context) {
        const values = [];
        const $checkboxes = $(context)
          .find('input[type="checkbox"]:checked + label')
          .not(
            '[data-drupal-selector="edit-visibility-entity-bundlecrm-contact-negate"] + label',
          );
        const il = $checkboxes.length;
        for (let i = 0; i < il; i++) {
          values.push($($checkboxes[i]).html());
        }
        const negated = $(context).find(
          'input[type="checkbox"][data-drupal-selector="edit-visibility-entity-bundlecrm-contact-negate"]:checked + label',
        );

        if (!values.length) {
          return Drupal.t('Not restricted');
        }
        const bundles = values.join(', ');
        if (negated.length) {
          return Drupal.t('Except @bundles', { '@bundles': bundles });
        }
        return bundles;
      }

      $(
        '[data-drupal-selector="edit-visibility-entity-bundlecrm-contact"]',
      ).drupalSetSummary(checkboxesSummary);
    },
  };
})(jQuery, window, Drupal);
