<?php

namespace Drupal\crm;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the contact entity type.
 */
class ContactAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected $viewLabelOperation = TRUE;

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    $bundle = $entity->bundle();

    switch ($operation) {
      case 'view label':
        $permissions = ['view any crm_contact label'];
        $permissions[] = "view any $bundle crm_contact label";

        return AccessResult::allowedIfHasPermissions($account, $permissions, 'OR');

      case 'view':
        $permissions = ['view any crm_contact'];
        $permissions[] = "view any $bundle crm_contact";

        return AccessResult::allowedIfHasPermissions($account, $permissions, 'OR');

      case 'update':
        $permissions = ['edit any crm_contact'];
        $permissions[] = "edit any $bundle crm_contact";

        return AccessResult::allowedIfHasPermissions($account, $permissions, 'OR');

      case 'delete':
        $permissions = ['delete any crm_contact'];
        $permissions[] = "delete any $bundle crm_contact";

        return AccessResult::allowedIfHasPermissions($account, $permissions, 'OR');

      default:
        // No opinion.
        return AccessResult::neutral();

    }

  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions(
      $account,
      ['create crm_contact', "create $entity_bundle crm_contact"],
      'OR',
    );
  }

}
