<?php

namespace Drupal\crm\Entity;

use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\crm\DetailTypeListBuilder;
use Drupal\crm\Form\DetailTypeForm;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\crm\CrmDetailTypeInterface;

/**
 * Defines the detail type entity type.
 */
#[ConfigEntityType(
  id: 'crm_detail_type',
  label: new TranslatableMarkup('Detail Type'),
  label_collection: new TranslatableMarkup('Detail Types'),
  label_singular: new TranslatableMarkup('detail type'),
  label_plural: new TranslatableMarkup('detail types'),
  label_count: [
    'singular' => '@count detail type',
    'plural' => '@count detail types',
  ],
  handlers: [
    'form' => [
      'add' => DetailTypeForm::class,
      'edit' => DetailTypeForm::class,
      'delete' => EntityDeleteForm::class,
    ],
    'list_builder' => DetailTypeListBuilder::class,
  ],
  admin_permission: 'administer crm',
  config_prefix: 'crm_detail_type',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
    'uuid' => 'uuid',
  ],
  links: [
    'add-form' => '/admin/structure/crm/detail-type/add',
    'edit-form' => '/admin/structure/crm/detail-type/manage/{crm_detail_type}',
    'delete-form' => '/admin/structure/crm/detail-type/manage/{crm_detail_type}/delete',
    'collection' => '/admin/structure/crm/detail-type',
  ],
  config_export: [
    'id',
    'label',
    'description',
    'bundles',
    'negate',
  ],
)]
class DetailType extends ConfigEntityBase implements CrmDetailTypeInterface {

  /**
   * The detail type id.
   *
   * @var string
   */
  protected $id;

  /**
   * The detail type label.
   *
   * @var string
   */
  protected $label;

  /**
   * The detail type status.
   *
   * @var bool
   */
  protected $status;

  /**
   * The crm_detail_type description.
   *
   * @var string
   */
  protected $description;

  /**
   * The bundles associated with this detail type.
   *
   * @var array
   */
  protected $bundles;

  /**
   * The negate condition for this detail type.
   *
   * @var bool
   */
  protected $negate;

}
