<?php

declare(strict_types=1);

namespace Drupal\crm\Field;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * The age field item list.
 */
class AgeFieldItemList extends FieldItemList {
  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $entity = $this->getEntity();

    $start = $entity->get('start_date')->value;
    $end = $entity->get('end_date')->value;

    if ($start) {
      $start_date = new \DateTime($start);
      $end_date = new \DateTime($end ?: 'now');

      $interval = $start_date->diff($end_date);
      $days = (int) $interval->format('%a');

      $this->list[0] = $this->createItem(0, $days);
    }
  }

}
