<?php

namespace Drupal\crm\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the relation entity edit forms.
 */
class UserContactForm extends ContentEntityForm {

  const SAVED_NEW = 1;
  const SAVED_UPDATED = 2;

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $relation = $this->getEntity();

    $query = $this->getRequest()->query;
    $crm_contact_id = $query->get('crm_contact');
    $user_id = $query->get('user');
    if ($crm_contact_id || $user_id) {
      $relation->setContactId($crm_contact_id);
      $relation->setUserId($user_id);
      $this->setEntity($relation);
    }

    $form = parent::form($form, $form_state);
    $is_new = $relation->isNew();

    if ($crm_contact_id) {
      $form['crm_contact']['widget']['#disabled'] = TRUE;
    }

    if ($user_id || !$is_new) {
      $form['user']['widget']['#disabled'] = TRUE;
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {

    $entity = $this->getEntity();
    $result = $entity->save();
    $link = $entity->toLink($this->t('View'))->toString();

    $logger_arguments = ['link' => $link];

    if ($result == self::SAVED_NEW) {
      $this->messenger()->addMessage($this->t('New user contact mapping has been created.'));
      $this->logger('crm')->notice('Created new user contact mapping', $logger_arguments);
    }
    else {
      $this->messenger()->addMessage($this->t('The user contact mapping has been updated.'));
      $this->logger('crm')->notice('User contact mapping updated', $logger_arguments);
    }

    $form_state->setRedirect('entity.crm_user_contact.collection');

    return $result;
  }

}
