<?php

namespace Drupal\crm\Plugin\Group\Relation;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\group\Plugin\Group\Relation\GroupRelationTypeInterface;
use Drupal\crm\Entity\ContactType;

/**
 * Derives plugins based on contact type.
 */
class GroupContactDeriver extends DeriverBase {

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    assert($base_plugin_definition instanceof GroupRelationTypeInterface);
    $this->derivatives = [];

    foreach (ContactType::loadMultiple() as $name => $contact_type) {
      $label = $contact_type->label();

      $this->derivatives[$name] = clone $base_plugin_definition;
      $this->derivatives[$name]->set('entity_bundle', $name);
      $this->derivatives[$name]->set('label', t('Group contact (@type)', ['@type' => $label]));
      $this->derivatives[$name]->set('description', t('Adds %type contact to groups both publicly and privately.', ['%type' => $label]));
    }

    return $this->derivatives;
  }

}
