# CRM Group Integration

The CRM module integrates with Drupal's Group module to help you organize and manage access to your contacts. This integration allows you to add contacts to groups, control who can see and edit them, and organize your contact database by teams, departments, projects, or any other grouping that makes sense for your organization.

## Overview

When you combine CRM with the Group module, you can:

- **Organize Contacts**: Add contacts to groups like departments, project teams, or client lists
- **Control Access**: Give specific people or roles access to contacts through group membership
- **Manage Permissions**: Set different permission levels for different groups (some can view, others can edit)
- **Separate Contact Types**: Add different types of contacts (people, households, organizations) to different groups
- **Keep Data Secure**: Ensure sensitive contact information is only accessible to authorized group members

## Requirements

To use CRM with groups, you need:

- **CRM Module**: Already installed as part of your setup
- **Group Module**: Version 2.x or 3.x
  - Available on Drupal.org
  - Install through Composer or the Drupal admin interface
- **Appropriate Permissions**: Administrative access to configure group types and relations

## How It Works

The CRM-Group integration creates separate connection types for each kind of contact you have in your system. For example:

- **Group contact (Person)** - For adding individual people to groups
- **Group contact (Household)** - For adding household contacts to groups
- **Group contact (Organization)** - For adding company or organizational contacts to groups

Each contact can only be added to a group once, which prevents confusion and duplicate entries. If you need to represent multiple relationships or roles, you can use CRM's relationship features alongside groups.

### Automatic Creation

The integration automatically creates these connection options based on the contact types you've configured in your CRM. When you add a new contact type, the corresponding group relation will be available for use.

## Setting Up Group Integration

### Step 1: Install the Group Module

First, make sure the Group module is installed on your Drupal site. You can install it from Drupal.org or through your site's module management interface.

### Step 2: Enable Contact Relations for Your Group Types

Once both CRM and Group modules are active:

1. **Navigate to Group Types**
   - Go to Administration → Groups → Group types
   - Or visit: `/admin/group/types`

2. **Select a Group Type**
   - Click on the group type you want to configure (e.g., "Department", "Project", "Team")
   - Each group type can have different contact relation settings

3. **Install Contact Relations**
   - Click the "Content" or "Relations" tab
   - You'll see available content types that can be added to this group type
   - Look for the "Group contact" options:
     - **Group contact (Person)** - For individual contacts
     - **Group contact (Household)** - For family/household contacts
     - **Group contact (Organization)** - For company contacts
   - Click "Install" next to each contact type you want to use with this group

4. **Configure Settings** (Optional)
   - After installing, click "Configure" to adjust settings
   - You can set how many times this relation can be used
   - Enable or disable the ability to create new contacts directly from the group
   - Note: Each contact can only be added once to prevent duplicates

### Step 3: Set Permissions

Configure who can add, view, edit, and remove contacts from groups:

1. Navigate to the group type's roles
2. For each role (like Member, Admin, etc.), set permissions for contact operations
3. Save your permission settings

## Using Groups with Contacts

### Adding Contacts to a Group

Once you've configured your group types to work with contacts, adding them is straightforward:

1. **Navigate to the Group**
   - Go to the group's page (e.g., a specific department or project team)

2. **Add Content to the Group**
   - Look for an "Add content" button or "Add member" link
   - Click it to see available content types

3. **Select the Contact Type**
   - Choose the appropriate option:
     - "Group contact (Person)" for individuals
     - "Group contact (Household)" for households
     - "Group contact (Organization)" for companies

4. **Search and Select the Contact**
   - Start typing the contact's name in the search field
   - Select the correct contact from the dropdown list
   - The system will show you matching contacts as you type

5. **Save**
   - Click the save button to add the contact to the group
   - The contact is now associated with this group

### Viewing Contacts in a Group

Group members with appropriate permissions can see all contacts that belong to their group:

1. **Access the Group**
   - Navigate to the group's main page

2. **View Group Content**
   - Look for a "Content" or "Members" tab
   - You'll see a list of all content added to the group, including contacts

3. **Filter by Type** (if available)
   - You may be able to filter to show only contacts
   - Or separate views for people, households, and organizations

### Managing Group Contacts

Depending on your permissions, you can:

- **View Contact Details**: Click on a contact's name to see their full information
- **Edit Contacts**: Make changes to contact information if you have edit permissions
- **Remove from Group**: Remove a contact's association with the group (this doesn't delete the contact, just removes them from this group)
- **See Group Membership**: View which groups a contact belongs to from their contact page

## Understanding Permissions

The Group module gives you fine-grained control over who can do what with contacts in your groups. After you install contact relations for a group type, new permissions become available for each group role.

### Available Permissions for Each Contact Type

For each contact type (Person, Household, Organization), you can control:

#### Viewing Permissions

- **View any [Type] contact**
  - Allows viewing all contacts of this type in the group
  - User can see any contact, regardless of who added it
  - Good for managers and team leaders

- **View own [Type] contact**
  - Allows viewing only contacts the user personally added to the group
  - More restrictive option
  - Good for contributors with limited access

#### Adding/Creating Permissions

- **Create [Type] contact**
  - Allows adding existing contacts to the group
  - May also allow creating new contacts directly from the group (if enabled in settings)
  - Essential for team members who manage contact lists

#### Editing Permissions

- **Update any [Type] contact**
  - Allows editing all contacts of this type in the group
  - User can modify any contact's information
  - Good for administrators and data managers

- **Update own [Type] contact**
  - Allows editing only contacts the user added to the group
  - More limited editing capabilities
  - Good for users who maintain specific contacts

#### Removing Permissions

- **Delete any [Type] contact**
  - Allows removing any contact from the group
  - Note: This removes the contact from the group, not from the entire system
  - Good for group administrators

- **Delete own [Type] contact**
  - Allows removing only contacts the user added to the group
  - More restricted removal capability
  - Good for regular members

### Setting Up Permissions

To configure permissions for your groups:

1. **Navigate to Group Type Roles**
   - Go to Administration → Groups → Group types
   - Select your group type
   - Click on "Roles" or "Permissions"

2. **Configure Each Role**
   - You'll see roles like "Member," "Admin," "Manager," etc.
   - For each role, check the boxes for the permissions you want to grant
   - Consider the level of trust and responsibility for each role

3. **Common Permission Patterns**
   - **Viewers**: Give "View any" permissions only
   - **Contributors**: Give "View any" and "Create" permissions
   - **Editors**: Give "View any," "Create," and "Update any" permissions
   - **Administrators**: Give all permissions (view, create, update, delete)

## How Access Control Works

The CRM-Group integration combines two permission systems to give you flexible access control. Understanding how these work together helps you set up secure and efficient contact management.

### Two Layers of Permissions

**Layer 1: CRM Module Permissions**
These are site-wide permissions that apply everywhere:
- Set in Administration → People → Permissions
- Examples: "View any CRM contact," "Edit any CRM contact"
- Apply regardless of group membership

**Layer 2: Group Permissions**
These are specific to each group:
- Set per group type and group role
- Only apply within the specific group
- Can grant additional access beyond CRM permissions

### How They Work Together

Users can access contacts if they have permission from EITHER layer:

1. **Direct CRM Access**: If a user has site-wide CRM permissions, they can access contacts across the entire site
2. **Group-Based Access**: If a user is a member of a group containing the contact, they can access it through their group role permissions
3. **Combined Access**: Users get the combined benefits of both permission systems

### Real-World Examples

**Example 1: Department Manager**
- Sarah is a manager in the "Marketing" group
- She has no site-wide CRM permissions
- Her group role gives her "view any person contact" permission
- She can see all person contacts that have been added to the Marketing group
- She cannot see contacts in other departments

**Example 2: System Administrator**
- John has site-wide "view any CRM contact" permission
- Even if a contact isn't in any of his groups, he can still see it
- His CRM permissions give him access everywhere

**Example 3: Team Member**
- Lisa is a member of both "Sales Team A" and "Sales Team B" groups
- She has "view any person contact" permission in both groups
- She can see person contacts in either team
- She cannot see contacts in "Sales Team C" where she's not a member

**Example 4: Limited Access**
- Mark has "view own person contact" permission in his group
- He can only see person contacts that he personally added to the group
- He cannot see contacts that other team members added

### Best Practices for Access Control

**For Secure Organizations:**
- Don't grant site-wide CRM permissions to regular users
- Use groups to control access on a need-to-know basis
- Create specific groups for sensitive contact information
- Use "own" permissions for users who contribute but shouldn't see everything

**For Collaborative Organizations:**
- Give "view any" permissions within groups to encourage collaboration
- Allow "create" permissions so team members can add contacts
- Restrict "delete" permissions to administrators
- Balance between security and usability

## What Happens When You Delete Things

### Deleting a Contact Type

If you delete a contact type (like "Person" or "Organization"):
- The corresponding group relation ("Group contact (Person)") is automatically removed
- Contacts of that type are removed from all groups
- This ensures your system stays consistent

### Deleting a Contact from a Group

When you remove a contact from a group:
- The contact still exists in your CRM
- It's only removed from that specific group
- The contact can still be in other groups
- The contact's information is not deleted

### Deleting a Contact Entirely

When you delete a contact from the CRM:
- It's automatically removed from all groups
- All group associations are cleaned up
- This prevents broken links in your groups

## Common Use Cases

### Company Departments

**Scenario:** Your organization has multiple departments that need to manage their own contacts.

**How to Set It Up:**
1. Create a group for each department (HR, Marketing, Sales, IT, etc.)
2. Install the "Group contact (Person)" relation for your department group type
3. Set permissions so department members can view and edit their department's contacts
4. Add employee contacts to their respective department groups

**Benefits:**
- Each department manages its own contact list
- HR can maintain employee records within their group
- Department managers can control who sees what within their team
- Contacts can belong to multiple departments if needed (someone in both IT and Management)

### Project Teams

**Scenario:** You manage multiple projects, each needing access to specific contacts like clients, vendors, and team members.

**How to Set It Up:**
1. Create a group for each project
2. Enable person and organization contact relations
3. Give project managers full permissions, team members view/create permissions
4. Add relevant contacts to each project group

**Benefits:**
- Team members automatically see contacts relevant to their projects
- When someone joins a project, they get access to project contacts immediately
- When someone leaves a project team, they lose access automatically
- Project managers control which contacts are associated with their projects

### Sales Team Client Assignment

**Scenario:** Multiple sales teams each need to manage their own client contacts without seeing other teams' clients.

**How to Set It Up:**
1. Create a group for each sales team
2. Install the "Group contact (Organization)" relation
3. Give team members permission to view and create organization contacts in their group
4. Give team leaders permission to edit and remove contacts
5. Assign client organizations to appropriate sales team groups

**Benefits:**
- Sales teams only see their assigned clients
- Competition and conflicts between teams are reduced
- Team leaders can reassign clients by moving them between groups
- Management can see all clients if they have site-wide permissions
- Clients can be in multiple teams' groups if they're joint accounts

### Event or Program Management

**Scenario:** You run events or programs and need to manage participant, volunteer, and sponsor contacts.

**How to Set It Up:**
1. Create a group for each event or program
2. Enable person, household, and organization contact relations
3. Add participants (person), families (household), and sponsors (organization) to the event group
4. Give event coordinators full access, volunteers limited access

**Benefits:**
- All event-related contacts in one place
- Easy to see who's involved with each event
- Can copy or reference contacts from previous events
- Contacts maintain their history across multiple events

### Privacy and Confidential Information

**Scenario:** Some contacts contain sensitive information that should only be accessible to specific people.

**How to Set It Up:**
1. Create private groups for sensitive contact categories (executive team, board members, legal matters, etc.)
2. Set the group type to "private" so only members can see it exists
3. Give access only to trusted personnel
4. Add sensitive contacts only to these restricted groups
5. Don't grant site-wide CRM permissions to general users

**Benefits:**
- Sensitive contacts are isolated and protected
- Clear audit trail of who has access
- Easy to grant or revoke access by adding/removing people from the group
- Confidential information stays confidential

### Geographic or Regional Organization

**Scenario:** Your organization operates in multiple locations, and each region needs its own contact list.

**How to Set It Up:**
1. Create groups for each region (North America, Europe, Asia-Pacific, etc.) or specific offices
2. Enable all contact types relevant to your business
3. Add contacts to the regions where they're located or relevant
4. Give regional managers full access to their region, staff view access

**Benefits:**
- Regional teams manage their local contacts
- Contacts are organized geographically
- Easy to find contacts in specific areas
- Support for contacts that span multiple regions

### Multi-Organization or Umbrella Organizations

**Scenario:** You're part of an umbrella organization with multiple member organizations, each needing their own contact space.

**How to Set It Up:**
1. Create a group for each member organization
2. Enable organization and person contact relations
3. Let each organization manage their own contacts within their group
4. Central administration can see across all groups if needed

**Benefits:**
- Member organizations maintain their own contact lists
- Privacy between member organizations
- Central coordination possible for umbrella activities
- Each organization controls its own data

## Working with Different Contact Types

The Group integration supports all types of contacts in your CRM:

### Available Contact Types

- **Person**: Individual contacts like employees, clients, volunteers, or members
- **Household**: Family units or household contacts
- **Organization**: Companies, businesses, nonprofits, or institutional contacts
- **Custom Types**: Any additional contact types you've created in your CRM

### Important Note

Each contact type has its own group relation. This means:
- You must separately install the relation for each contact type you want to use
- Person contacts use "Group contact (Person)"
- Organizations use "Group contact (Organization)"
- Households use "Group contact (Household)"
- Each has separate permissions that you configure independently

## Creating Custom Views and Reports

The Group integration works seamlessly with Drupal's Views system, allowing you to create custom lists and reports.

### What You Can Do

**Create Lists Of:**
- All contacts in a specific group
- All groups a contact belongs to
- Contacts of a specific type within groups
- Contact counts per group

**Filter and Sort By:**
- Group membership
- Contact type
- Date added to group
- Who added the contact
- Any contact field (name, email, phone, etc.)

**Export Options:**
- Export contact lists from groups
- Create CSV files of group members
- Generate reports for specific groups

### Example Scenarios

- List all organization contacts across all sales team groups
- Show which groups a specific contact belongs to
- Display recent contacts added to a department group
- Create a directory of all people in project teams

## Important Limitations

### One Contact, One Time Per Group

**What This Means:**
Each contact can only be added to a specific group once. You cannot add the same contact multiple times to the same group.

**Why This Matters:**
This prevents confusion and duplicate entries. If you try to add a contact that's already in the group, you'll get an error message.

**What If I Need Multiple Roles?**
If a contact needs to have multiple roles or relationships within a group (like someone who is both a volunteer and a donor), you have options:
- Use CRM's relationship features to define these roles
- Add custom fields to track multiple roles
- Create multiple groups for different roles and add the contact to each

### Separate Setup for Each Contact Type

**What This Means:**
Person contacts, household contacts, and organization contacts are treated as completely separate things in groups.

**What You Need to Do:**
- Install the relation for each contact type separately
- Configure permissions for each type separately
- Each type appears as a different option when adding content to groups

**Why It's This Way:**
This gives you maximum flexibility. For example:
- A project group might allow person and organization contacts but not households
- Sales teams might only need organization contacts
- Community groups might need all three types

### Group Module Is Optional

**What This Means:**
The CRM module works perfectly fine without the Group module installed. The Group integration only activates when you have both modules installed.

**Implications:**
- You can start using CRM without Groups and add it later
- If you uninstall the Group module, your contacts remain intact
- Group features only appear when Group is enabled

## Troubleshooting Common Issues

### I Don't See the Group Contact Option

**Problem:** The "Group contact" options don't appear when configuring your group type.

**Possible Solutions:**

1. **Verify the Group Module Is Installed**
   - Go to Administration → Extend
   - Look for "Group" in the module list
   - Make sure it's enabled (checked)

2. **Clear Your Site Cache**
   - Go to Administration → Configuration → Development → Performance
   - Click "Clear all caches"
   - Or use the admin toolbar cache clear button

3. **Check That Contact Types Exist**
   - Go to Administration → Structure → CRM → Contact types
   - Verify that you have at least one contact type (Person, Household, or Organization)
   - If no contact types exist, create them first

4. **Look for Error Messages**
   - Check the "Recent log messages" at Administration → Reports → Recent log messages
   - Look for errors related to CRM or Group modules

### I Can't Add a Contact to a Group

**Problem:** You get an error when trying to add a contact to a group.

**Common Causes and Solutions:**

1. **Contact Already in Group**
   - Each contact can only be added once per group
   - Check if the contact is already listed in the group's content
   - If you see "already exists" or similar error, the contact is already there

2. **Missing Permissions**
   - You may not have permission to add content to this group
   - Ask a group administrator to check your role's permissions
   - You need "Create [Type] contact" permission for the group role

3. **Wrong Contact Type**
   - Make sure the group relation is installed for this contact type
   - Example: If trying to add a Person, "Group contact (Person)" must be installed
   - Check the group type configuration under Content/Relations tab

4. **Contact Type Relation Not Installed**
   - The group type may not be configured to accept this contact type
   - Go to the group type configuration
   - Install the appropriate "Group contact" relation

### Users Can't See Contacts in Groups

**Problem:** Group members say they can't see contacts that should be in their group.

**Things to Check:**

1. **Group Role Permissions**
   - Go to the group type's permissions page
   - Find the user's role (Member, Admin, etc.)
   - Make sure "View any [Type] contact" or "View own [Type] contact" is checked
   - Save if you made changes

2. **User Is Actually a Member**
   - Go to the group's member list
   - Verify the user appears in the list
   - Check their role assignment
   - Add them if they're not listed

3. **Caches Need Clearing**
   - After changing permissions, clear the site cache
   - Sometimes users need to log out and back in
   - Try in a private/incognito browser window

4. **Site-Wide CRM Permissions**
   - Check if CRM permissions are blocking access
   - Go to Administration → People → Permissions
   - Look for CRM-related permissions
   - Make sure they're not set in a conflicting way

5. **Contact Actually in the Group**
   - Double-check the contact was successfully added
   - View the group's content list as an administrator
   - Verify the contact appears there

### Contact Is in Multiple Groups But Users Only See Some

**Problem:** A contact belongs to multiple groups, but users don't see it in all of them.

**Explanation:**
This is normal behavior. Users only see contacts in groups where they:
- Are a member of the group, AND
- Have permission to view that contact type in that group

**Solution:**
If a user should see the contact in more groups:
1. Add them as a member to those groups
2. Or give them site-wide CRM viewing permissions

## Tips for Success

### Start Small

If you're new to using Groups with CRM:
1. Start with one group type and one contact type
2. Test the permissions with a few test users
3. Make sure you understand how access control works
4. Gradually expand to more groups and contact types

### Plan Your Group Structure

Before creating lots of groups, think about:
- **Purpose**: What is each group for?
- **Access**: Who needs to see what contacts?
- **Organization**: How will you organize contacts? By department? Project? Region?
- **Permissions**: What level of access does each role need?

### Document Your Permissions

Keep track of which roles have which permissions in each group type. This helps when:
- Training new administrators
- Troubleshooting access issues
- Planning group structure changes
- Auditing who has access to what

### Regular Cleanup

Periodically review:
- Contacts that are in multiple groups (is this still necessary?)
- Inactive groups that can be archived or deleted
- Users who no longer need group access
- Permissions that may have changed over time

### Train Your Users

Make sure your team understands:
- How to add contacts to groups
- What their permissions allow them to do
- The difference between removing from a group vs. deleting entirely
- How to find contacts across their groups
- Who to contact if they need different permissions

## Organizing Existing Contacts into Groups

If you already have many contacts in your CRM and want to organize them into groups:

### Manual Organization

**For Small Numbers of Contacts:**
1. Create your groups first
2. Open each contact you want to add
3. Find which groups it belongs to (or open the group and add from there)
4. Add contacts one by one or in small batches

**Tips:**
- Start with your most important contacts or groups
- Work through one category at a time (all employees, then all clients, etc.)
- Keep a checklist of which contacts you've assigned

### Using Bulk Operations

**For Larger Numbers of Contacts:**
1. Create a View of contacts (Administration → Structure → Views)
2. Add filters to find the contacts you want to group
3. Use the "Bulk operations" feature if your site has it configured
4. Select multiple contacts and assign them to groups

### Systematic Approach

**Organizing by Criteria:**

If you want to organize contacts based on certain criteria:
1. **By Type**: Put all organizations in one set of groups, people in another
2. **By Field Value**: Use contact fields (like department, region, status) to determine group assignment
3. **By Date**: Recent contacts vs. older contacts
4. **By Relationship**: Group contacts based on their relationships with other contacts

**Process:**
1. Create Views with appropriate filters for each criterion
2. Export the contact lists
3. Review and plan which groups they should be in
4. Add them systematically, working through one group at a time
