<?php

declare(strict_types=1);

namespace Drupal\crm;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\RevisionableEntityBundleInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Interface for CRM contact type entities.
 */
interface CrmContactTypeInterface extends ConfigEntityInterface, RevisionableEntityBundleInterface, EntityDescriptionInterface {

  /**
   * Determines whether the contact detail type is locked.
   *
   * @return string|false
   *   The module name that locks the type or FALSE.
   */
  public function isLocked();

  /**
   * Sets whether a new revision should be created by default.
   *
   * @param bool $new_revision
   *   TRUE if a new revision should be created by default.
   */
  public function setNewRevision($new_revision);

  /**
   * Gets the description.
   *
   * @return string
   *   The description of this contact detail type.
   */
  public function getDescription();

}
