<?php

declare(strict_types=1);

namespace Drupal\crm\Entity\ContactDetail;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\crm\Entity\ContactDetail;

/**
 * A base bundle class for crm_contact_detail entities.
 */
abstract class ContactDetailBase extends ContactDetail {

  use StringTranslationTrait;

  /**
   * Gets the entity label without the type.
   *
   * @return string
   *   The label without the type.
   */
  abstract public function getLabelWithoutType(): string;

  /**
   * {@inheritdoc}
   */
  public function label() {
    if ($this->get('type')->isEmpty()) {
      return $this->getLabelWithoutType();
    }

    /** @var \Drupal\Core\Entity\Plugin\DataType\EntityReference $detail_type_entity_reference */
    $detail_type_entity_reference = $this
      ->get('type')
      ->first()
      ->get('entity');

    /** @var \Drupal\crm\CrmDetailTypeInterface $detail_type_entity */
    $detail_type_entity = $detail_type_entity_reference
      ->getTarget()
      ->getValue();

    $type = $detail_type_entity?->label();

    return $this->t('@type: @label', [
      '@type' => $type,
      '@label' => $this->getLabelWithoutType(),
    ]);
  }

}
