<?php

declare(strict_types=1);

namespace Drupal\Tests\crm\Unit;

use Drupal\crm\Hook\EntityHooks;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

require_once __DIR__ . '/../../../crm.module';

/**
 * Tests hook_entity_bundle_info_alter.
 *
 * @group crm
 */
class HookEntityBundleInfoAlterTest extends UnitTestCase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->createMock('Drupal\Core\StringTranslation\TranslationInterface');
    $container->set('string_translation', $string_translation);

    \Drupal::setContainer($container);
  }

  /**
   * Tests hook_entity_bundle_info_alter().
   */
  public function testCrmEntityBundleInfoAlter() {
    $bundles = [
      'crm_contact_detail' => [
        'address' => [],
        'email' => [],
        'telephone' => [],
      ],
    ];

    $entityHooks = new EntityHooks();
    $entityHooks->entityBundleInfoAlter($bundles);

    $this->assertArrayHasKey('class', $bundles['crm_contact_detail']['address']);
    $this->assertEquals('Drupal\crm\Entity\ContactDetail\AddressContactDetail', $bundles['crm_contact_detail']['address']['class']);
    $this->assertArrayHasKey('class', $bundles['crm_contact_detail']['email']);
    $this->assertEquals('Drupal\crm\Entity\ContactDetail\EmailContactDetail', $bundles['crm_contact_detail']['email']['class']);
    $this->assertArrayHasKey('class', $bundles['crm_contact_detail']['telephone']);
    $this->assertEquals('Drupal\crm\Entity\ContactDetail\TelephoneContactDetail', $bundles['crm_contact_detail']['telephone']['class']);
  }

}
