<?php

declare(strict_types=1);

namespace Drupal\crm;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Interface for CRM contact type entities.
 */
interface CrmContactDetailTypeInterface extends ConfigEntityInterface, EntityDescriptionInterface {

  /**
   * Determines whether the contact detail type is locked.
   *
   * @return string|false
   *   The module name that locks the type or FALSE.
   */
  public function isLocked();

  /**
   * Gets the description.
   *
   * @return string
   *   The description of this contact detail type.
   */
  public function getDescription();

}
