<?php

namespace Drupal\crm\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\crm\CrmUserContactInterface;

/**
 * Event that is fired when a user is created, and auto create is enabled.
 */
class CrmUserContactEvent extends Event {

  /**
   * The event name.
   *
   * @var string
   */
  const EVENT_NAME = 'crm_user_contact_event';


  /**
   * The crm user contact.
   *
   * @var \Drupal\crm\CrmUserContactInterface
   */
  protected $crmUserContact;

  /**
   * Constructs a new CrmUserContactEvent.
   *
   * @param \Drupal\crm\CrmUserContactInterface $crm_user_contact
   *   The crm user contact.
   */
  public function __construct(CrmUserContactInterface $crm_user_contact) {
    $this->crmUserContact = $crm_user_contact;
  }

  /**
   * Get the crm user contact.
   *
   * @return \Drupal\crm\CrmUserContactInterface
   *   The crm user contact.
   */
  public function getCrmUserContact(): CrmUserContactInterface {
    return $this->crmUserContact;
  }

  /**
   * Set the crm user contact.
   *
   * @param \Drupal\crm\CrmUserContactInterface $crm_user_contact
   *   The crm user contact.
   */
  public function setCrmUserContact(CrmUserContactInterface $crm_user_contact): void {
    $this->crmUserContact = $crm_user_contact;
  }

}
