<?php

namespace Drupal\crm\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Config\ConfigInstallerInterface;
use Drupal\Core\Config\FileStorage;
use Drupal\Core\Extension\ModuleExtensionList;

/**
 * Hooks relating to installing optional config.
 */
class InstallOptionalConfigHooks {

  /**
   * Constructs a new InstallOptionalConfigHooks object.
   *
   * @param \Drupal\Core\Config\ConfigInstallerInterface $configInstaller
   *   The config installer.
   * @param \Drupal\Core\Extension\ModuleExtensionList $moduleExtensionList
   *   The module extension list.
   */
  public function __construct(
    protected ConfigInstallerInterface $configInstaller,
    protected ModuleExtensionList $moduleExtensionList,
  ) {}

  /**
   * Implements hook_modules_installed().
   */
  #[Hook('modules_installed')]
  public function modulesInstalled(array $modules) {
    if (!in_array('search', $modules)) {
      return;
    }

    // Restrict to only your module's optional config.
    $storage = new FileStorage($this->moduleExtensionList->getPath('crm') . '/config/optional');
    foreach ($modules as $module) {
      // Restrict to configs that depend on the module just installed.
      $this->configInstaller->installOptionalConfig($storage, [
        'module' => $module,
      ]);
    }
  }

}
