<?php

namespace Drupal\crm\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hooks relating to miscellaneous.
 */
class MiscHooks {

  /**
   * Implements hook_views_data_alter().
   *
   * @todo Remove once https://www.drupal.org/project/drupal/issues/2706431 is
   * resolved.
   */
  #[Hook('views_data_alter')]
  public function viewsDataAlter(array &$data) {
    $title = t('CRM User Sync Relation');
    $data['users_field_data']['crm_user_contact'] = [
      'title' => $title,
      'help' => t('Adds relation to CRM User Sync Relation that point to current user.'),
      'relationship' => [
        'base' => 'crm_user_contact',
        'base field' => 'user',
        'field' => 'uid',
        'id' => 'standard',
        'label' => $title,
      ],
    ];

    $data['users_field_data']['crm_user_contact_sync_form'] = [
      'title' => t('Contact relation'),
      'help' => t("Provides a link to the user's contact relation form."),
      'field' => [
        'id' => 'crm_contact_user',
      ],
    ];
    $data['users_field_data']['crm_core_user_sync_form'] = [
      'title' => t('Contact relation'),
      'help' => t("Provides a link to the user's contact relation form."),
      'field' => [
        'id' => 'crm_user_contact',
      ],
    ];

    $data['crm_contact']['crm_user_contact'] = [
      'title' => $title,
      'help' => t('Adds relation to CRM User Sync Relation that point to current person.'),
      'relationship' => [
        'base' => 'crm_user_contact',
        'base field' => 'crm_contact',
        'field' => 'id',
        'id' => 'standard',
        'label' => $title,
      ],
    ];

    $data['crm_contact']['crm_core_user_sync_form'] = [
      'title' => t('User relation'),
      'help' => t("Provides a link to the person's user relation form."),
      'field' => [
        'id' => 'crm_user_contact',
        'field_name' => 'user',
      ],
    ];

  }

}
