<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that Relationship Contacts are different.
 */
#[Constraint(
  id: 'RelationshipContacts',
  label: new TranslatableMarkup('Relationship Contacts', [], ['context' => 'Validation'])
)]
class RelationshipContactsConstraint extends SymfonyConstraint {

  /**
   * The message shown when the contacts are different.
   *
   * @var string
   */
  public $differentMessage = 'Relationship Contacts must be different.';

  /**
   * The message shown when the contacts are of the wrong type.
   *
   * @var string
   */
  public $wrongTypeMessage = 'Relationship Contacts must be of type @type.';

}
