<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that Contact A and Contact B are different.
 */
class RelationshipContactsConstraintValidator extends ConstraintValidator {

  /**
   * Validates the entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity being validated.
   * @param \Drupal\crm\Plugin\Validation\Constraint\RelationshipContactsConstraint $constraint
   *   The constraint to validate against.
   */
  public function validate($entity, Constraint $constraint) {
    $contact_a = $entity->get('contacts')->referencedEntities()[0] ?? NULL;
    $contact_b = $entity->get('contacts')->referencedEntities()[1] ?? NULL;

    $contact_a_target_id = $contact_a ? $contact_a->id() : NULL;
    $contact_b_target_id = $contact_b ? $contact_b->id() : NULL;

    if ($contact_a_target_id === $contact_b_target_id) {
      $this->context->addViolation($constraint->differentMessage);
    }

    $relationship_type = $entity->get('bundle')->entity ?? NULL;
    $expected_contact_a_type = $relationship_type ? $relationship_type->get('contact_type_a') : NULL;
    $expected_contact_b_type = $relationship_type ? $relationship_type->get('contact_type_b') : NULL;

    $contact_a_type = $contact_a ? $contact_a->bundle() : NULL;
    $contact_b_type = $contact_b ? $contact_b->bundle() : NULL;

    if ($expected_contact_a_type !== $contact_a_type) {
      $this->context->buildViolation($constraint->wrongTypeMessage)
        ->atPath('contact_a')
        ->setParameter('@type', $expected_contact_a_type)
        ->addViolation();
    }

    if ($expected_contact_b_type !== $contact_b_type) {
      $this->context->buildViolation($constraint->wrongTypeMessage)
        ->atPath('contact_b')
        ->setParameter('@type', $expected_contact_b_type)
        ->addViolation();
    }
  }

}
