<?php

namespace Drupal\crm\Plugin\views\query;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsQuery;
use Drupal\views\Plugin\views\query\QueryPluginBase;

/**
 * Views query plugin for a CRM user.
 */
#[ViewsQuery(
  id: 'crm_user_contact',
  title: new TranslatableMarkup('User Contact'),
  help: new TranslatableMarkup('Relationship between the user and person.')
)]
class CrmUserContact extends QueryPluginBase {

  /**
   * {@inheritdoc}
   */
  public function ensureTable($table, $relationship = NULL) {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function addField($table, $field, $alias = '', $params = []) {
    return $field;
  }

}
