<?php

declare(strict_types=1);

namespace Drupal\Tests\crm\Unit;

use Drupal\crm\Hook\EntityHooks;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

require_once __DIR__ . '/../../../crm.module';

/**
 * Tests hook_inline_entity_form_table_fields_alter.
 *
 * @group crm
 */
class HookInlineEntityFormTableFieldsAlterTest extends UnitTestCase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->createMock('Drupal\Core\StringTranslation\TranslationInterface');
    $container->set('string_translation', $string_translation);

    \Drupal::setContainer($container);
  }

  /**
   * Tests hook_inline_entity_form_table_fields_alter().
   */
  public function testCrmInlineEntityFormTableFieldsAlterAddress() {

    $fields = [];
    $context = [
      'allowed_bundles' => ['address'],
      'parent_entity_type' => 'crm_contact',
      'entity_type' => 'crm_contact_detail',
    ];

    $entityHooks = new EntityHooks();
    $entityHooks->inlineEntityFormTableFieldsAlter($fields, $context);

    $this->assertArrayHasKey('label', $fields);
    $this->assertArrayHasKey('label', $fields['label']);
    $this->assertEquals('Address (line 1)', $fields['label']['label']->getUntranslatedString());

  }

  /**
   * Tests hook_inline_entity_form_table_fields_alter().
   */
  public function testCrmInlineEntityFormTableFieldsAlterTelephone() {

    $fields = [];
    $context = [
      'allowed_bundles' => ['telephone'],
      'parent_entity_type' => 'crm_contact',
      'entity_type' => 'crm_contact_detail',
    ];

    $entityHooks = new EntityHooks();
    $entityHooks->inlineEntityFormTableFieldsAlter($fields, $context);

    $this->assertArrayHasKey('label', $fields);
    $this->assertArrayHasKey('label', $fields['label']);
    $this->assertEquals('Telephone', $fields['label']['label']->getUntranslatedString());

  }

  /**
   * Tests hook_inline_entity_form_table_fields_alter().
   */
  public function testCrmInlineEntityFormTableFieldsAlterEmail() {

    $fields = [];
    $context = [
      'allowed_bundles' => ['email'],
      'parent_entity_type' => 'crm_contact',
      'entity_type' => 'crm_contact_detail',
    ];

    $entityHooks = new EntityHooks();
    $entityHooks->inlineEntityFormTableFieldsAlter($fields, $context);

    $this->assertArrayHasKey('label', $fields);
    $this->assertArrayHasKey('label', $fields['label']);
    $this->assertEquals('Email', $fields['label']['label']->getUntranslatedString());

  }

}
