<?php

namespace Drupal\crm_case\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\crm_case\Form\CrmCaseTypeForm;
use Drupal\crm_case\CrmCaseTypeListBuilder;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the Crm Case type configuration entity.
 */
#[ConfigEntityType(
  id: 'crm_case_type',
  label: new TranslatableMarkup('CRM Case type'),
  label_collection: new TranslatableMarkup('CRM Case types'),
  label_singular: new TranslatableMarkup('crm case type'),
  label_plural: new TranslatableMarkup('crm cases types'),
  label_count: [
    'singular' => '@count crm cases type',
    'plural' => '@count crm cases types',
  ],
  handlers: [
    'form' => [
      'add' => CrmCaseTypeForm::class,
      'edit' => CrmCaseTypeForm::class,
      'delete' => EntityDeleteForm::class,
    ],
    'list_builder' => CrmCaseTypeListBuilder::class,
    'route_provider' => [
      'html' => AdminHtmlRouteProvider::class,
    ],
  ],
  admin_permission: 'administer crm',
  bundle_of: 'crm_case',
  config_prefix: 'crm_case_type',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
    'uuid' => 'uuid',
  ],
  links: [
    'add-form' => '/admin/structure/crm_case_types/add',
    'edit-form' => '/admin/structure/crm_case_types/manage/{crm_case_type}',
    'delete-form' => '/admin/structure/crm_case_types/manage/{crm_case_type}/delete',
    'collection' => '/admin/structure/crm_case_types',
  ],
  config_export: ['id', 'label', 'uuid'],
)]
class CrmCaseType extends ConfigEntityBundleBase {

  /**
   * The machine name of this crm case type.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable name of the crm case type.
   *
   * @var string
   */
  protected $label;

}
