<?php

declare(strict_types=1);

namespace Drupal\Tests\crm_case\Unit;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Tests\UnitTestCase;
use Drupal\crm_case\Entity\CrmCase;

/**
 * Tests the CrmCase entity unit functionality.
 *
 * @group crm_case
 * @coversDefaultClass \Drupal\crm_case\Entity\CrmCase
 */
class CrmCaseEntityTest extends UnitTestCase {

  /**
   * The entity under test.
   *
   * @var \Drupal\crm_case\Entity\CrmCase
   */
  protected $entity;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->createMock('Drupal\Core\StringTranslation\TranslationInterface');
    $container->set('string_translation', $string_translation);

    $entity_type_manager = $this->createMock('Drupal\Core\Entity\EntityTypeManagerInterface');
    $container->set('entity_type.manager', $entity_type_manager);

    $uuid_service = $this->createMock('Drupal\Component\Uuid\UuidInterface');
    $container->set('uuid', $uuid_service);

    $language_manager = $this->createMock('Drupal\Core\Language\LanguageManagerInterface');
    $container->set('language_manager', $language_manager);

    $cache_tags_invalidator = $this->createMock('Drupal\Core\Cache\CacheTagsInvalidatorInterface');
    $container->set('cache_tags.invalidator', $cache_tags_invalidator);

    \Drupal::setContainer($container);
  }

  /**
   * Tests the preSave method with no owner set.
   *
   * @covers ::preSave
   */
  // Public function testPreSaveWithNoOwner(): void {
  //   $storage = $this->createMock(EntityStorageInterface::class);.
  // // Create a mock CrmCase entity.
  //   $entity = $this->getMockBuilder(CrmCase::class)
  //     ->disableOriginalConstructor()
  //     ->onlyMethods(['getOwnerId', 'setOwnerId'])
  //     ->getMock();
  // // Mock that no owner is set initially.
  //   $entity->expects($this->once())
  //     ->method('getOwnerId')
  //     ->willReturn(NULL);
  // // Expect setOwnerId to be called with anonymous user (0).
  //   $entity->expects($this->once())
  //     ->method('setOwnerId')
  //     ->with(0);
  // $bundle = $this->createMock(EntityTypeInterface::class);
  //   $bundle->expects($this->once())
  //     ->method('getBundleOf')
  //     ->willReturn(CrmCase::class);
  // $entity->expects($this->once())
  //     ->method('getEntityTypeId')
  //     ->willReturn('crm_case');
  // // Call preSave.
  //   $entity->preSave($storage);
  // }

  /**
   * Tests the preSave method with existing owner.
   *
   * @covers ::preSave
   */
  // Public function testPreSaveWithExistingOwner(): void {
  //   $storage = $this->createMock(EntityStorageInterface::class);.
  // // Create a mock CrmCase entity.
  //   $entity = $this->getMockBuilder(CrmCase::class)
  //     ->disableOriginalConstructor()
  //     ->onlyMethods(['getOwnerId', 'setOwnerId'])
  //     ->getMock();
  // // Mock that an owner is already set.
  //   $entity->expects($this->once())
  //     ->method('getOwnerId')
  //     ->willReturn(123);
  // // setOwnerId should not be called.
  //   $entity->expects($this->never())
  //     ->method('setOwnerId');
  // // Call preSave.
  //   $entity->preSave($storage);
  // }

  /**
   * Tests that the entity implements the correct interfaces.
   */
  public function testEntityImplementsInterfaces(): void {
    $interfaces = class_implements(CrmCase::class);

    $this->assertContains('Drupal\crm_case\CrmCaseInterface', $interfaces);
    $this->assertContains('Drupal\Core\Entity\ContentEntityInterface', $interfaces);
    $this->assertContains('Drupal\Core\Entity\EntityChangedInterface', $interfaces);
    $this->assertContains('Drupal\user\EntityOwnerInterface', $interfaces);
  }

  /**
   * Tests that the entity uses the correct traits.
   */
  public function testEntityUsesTraits(): void {
    $traits = class_uses(CrmCase::class);

    $this->assertContains('Drupal\Core\Entity\EntityChangedTrait', $traits);
    $this->assertContains('Drupal\user\EntityOwnerTrait', $traits);
  }

  /**
   * Tests that the entity extends the correct base class.
   */
  public function testEntityExtendsCorrectBaseClass(): void {
    $this->assertInstanceOf(
      'Drupal\Core\Entity\RevisionableContentEntityBase',
      $this->getMockBuilder(CrmCase::class)
        ->disableOriginalConstructor()
        ->getMock()
    );
  }

}
