<?php

namespace Drupal\crm_case\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the crm case entity edit forms.
 */
class CrmCaseForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New crm case %label has been created.', $message_arguments));
        $this->logger('crm_case')->notice('Created new crm case %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The crm case %label has been updated.', $message_arguments));
        $this->logger('crm_case')->notice('Updated crm case %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.crm_case.canonical', ['crm_case' => $entity->id()]);

    return $result;
  }

}
