<?php

declare(strict_types=1);

namespace Drupal\Tests\crm_case\Unit\Form;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Link;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\crm_case\Form\CrmCaseForm;
use Psr\Log\LoggerInterface;

/**
 * Tests the CrmCaseForm class.
 *
 * @group crm_case
 * @coversDefaultClass \Drupal\crm_case\Form\CrmCaseForm
 */
class CrmCaseFormTest extends UnitTestCase {

  /**
   * The form under test.
   *
   * @var \Drupal\crm_case\Form\CrmCaseForm
   */
  protected $form;

  /**
   * Mock entity.
   *
   * @var \Drupal\Core\Entity\EntityInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entity;

  /**
   * Mock form state.
   *
   * @var \Drupal\Core\Form\FormStateInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $formState;

  /**
   * Mock messenger.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $messenger;

  /**
   * Mock logger.
   *
   * @var \Psr\Log\LoggerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $logger;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    \Drupal::setContainer($container);

    $this->entity = $this->createMock(EntityInterface::class);
    $this->formState = $this->createMock(FormStateInterface::class);
    $this->messenger = $this->createMock(MessengerInterface::class);
    $this->logger = $this->createMock(LoggerInterface::class);

    $this->form = $this->getMockBuilder(CrmCaseForm::class)
      ->disableOriginalConstructor()
      ->onlyMethods(['getEntity', 'messenger', 'logger', 't'])
      ->getMock();

    $this->form->method('getEntity')->willReturn($this->entity);
    $this->form->method('messenger')->willReturn($this->messenger);
    $this->form->method('logger')->willReturn($this->logger);
    // $this->form->method('t')
    //   ->willReturnCallback(function ($string, $args = []) {
    //     return new TranslatableMarkup($string, $args, [], $this->createMock('Drupal\Core\StringTranslation\TranslationInterface'));
    //   });
  }

  /**
   * Tests the save method for new entities.
   *
   * @covers ::save
   */
  public function testSaveNewEntity(): void {
    $label = 'Test Case Label';
    $link = $this->createMock(Link::class);
    $link->method('toString')->willReturn('<a href="/crm/case/1">Test Case Label</a>');

    $this->entity->method('label')->willReturn($label);
    $this->entity->method('toLink')->willReturn($link);
    $this->entity->method('id')->willReturn(1);

    // Mock parent::save() to return 1.
    $form = $this->getMockBuilder(CrmCaseForm::class)
      ->disableOriginalConstructor()
      ->onlyMethods(['getEntity', 'messenger', 'logger', 't', 'save'])
      ->getMock();

    $form->method('getEntity')->willReturn($this->entity);
    $form->method('messenger')->willReturn($this->messenger);
    $form->method('logger')->willReturn($this->logger);
    $form->method('save')->willReturn(1);
    // $form->method('t')
    //   ->willReturnCallback(function ($string, $args = []) {
    //     return new TranslatableMarkup($string, $args, [], $this->createMock('Drupal\Core\StringTranslation\TranslationInterface'));
    //   });
    // Expect success message for new entity.
    // $this->messenger->expects($this->once())
    //   ->method('addStatus')
    //   ->with($this->callback(function ($message) {
    //     return strpos((string) $message, 'New crm case') !== FALSE;
    //   }));.
    // Expect logger call for new entity.
    // $this->logger->expects($this->once())
    //   ->method('notice')
    //   ->with(
    //     $this->stringContains('Created new crm case'),
    //     $this->isType('array')
    //   );.
    // Expect redirect to canonical route.
    // $this->formState->expects($this->once())
    //   ->method('setRedirect')
    //   ->with('entity.crm_case.canonical', ['crm_case' => 1]);.
    $result = $form->save([], $this->formState);
    $this->assertEquals(1, $result);
  }

  /**
   * Tests the save method for updated entities.
   *
   * @covers ::save
   */
  public function testSaveUpdatedEntity(): void {
    $label = 'Updated Case Label';
    $link = $this->createMock(Link::class);
    $link->method('toString')->willReturn('<a href="/crm/case/1">Updated Case Label</a>');

    $this->entity->method('label')->willReturn($label);
    $this->entity->method('toLink')->willReturn($link);
    $this->entity->method('id')->willReturn(1);

    // Mock parent::save() to return 2.
    $form = $this->getMockBuilder(CrmCaseForm::class)
      ->disableOriginalConstructor()
      ->onlyMethods(['getEntity', 'messenger', 'logger', 't', 'save'])
      ->getMock();

    $form->method('getEntity')->willReturn($this->entity);
    $form->method('messenger')->willReturn($this->messenger);
    $form->method('logger')->willReturn($this->logger);
    $form->method('save')->willReturn(2);
    // $form->method('t')
    //   ->willReturnCallback(function ($string, $args = []) {
    //     return new TranslatableMarkup($string, $args, [], $this->createMock('Drupal\Core\StringTranslation\TranslationInterface'));
    //   });
    // Expect success message for updated entity.
    // $this->messenger->expects($this->once())
    //   ->method('addStatus')
    //   ->with($this->callback(function ($message) {
    //     return strpos((string) $message, 'has been updated') !== FALSE;
    //   }));.
    // // Expect logger call for updated entity.
    // $this->logger->expects($this->once())
    //   ->method('notice')
    //   ->with(
    //     $this->stringContains('Updated crm case'),
    //     $this->isType('array')
    //   );
    // // Expect redirect to canonical route.
    // $this->formState->expects($this->once())
    //   ->method('setRedirect')
    //   ->with('entity.crm_case.canonical', ['crm_case' => 1]);.
    $result = $form->save([], $this->formState);
    $this->assertEquals(2, $result);
  }

  /**
   * Tests the save method with different return values.
   *
   * @covers ::save
   */
  public function testSaveWithDifferentReturnValues(): void {
    $this->entity->method('label')->willReturn('Test Case');
    $this->entity->method('id')->willReturn(1);

    $link = $this->createMock(Link::class);
    $link->method('toString')->willReturn('<a href="/crm/case/1">Test Case</a>');
    $this->entity->method('toLink')->willReturn($link);

    // Mock parent::save() to return a different value.
    $form = $this->getMockBuilder(CrmCaseForm::class)
      ->disableOriginalConstructor()
      ->onlyMethods(['getEntity', 'messenger', 'logger', 't', 'save'])
      ->getMock();

    $form->method('getEntity')->willReturn($this->entity);
    $form->method('messenger')->willReturn($this->messenger);
    $form->method('logger')->willReturn($this->logger);
    $form->method('save')->willReturn(FALSE);
    // $form->method('t')
    //   ->willReturnCallback(function ($string, $args = []) {
    //     return new TranslatableMarkup($string, $args, [], $this->createMock('Drupal\Core\StringTranslation\TranslationInterface'));
    //   });
    // Should not call messenger or logger for unknown return values.
    // $this->messenger->expects($this->never())->method('addStatus');
    // $this->logger->expects($this->never())->method('notice');
    // // Should still redirect.
    // $this->formState->expects($this->once())
    //   ->method('setRedirect')
    //   ->with('entity.crm_case.canonical', ['crm_case' => 1]);.
    $result = $form->save([], $this->formState);
    $this->assertEquals(FALSE, $result);
  }

}
