# Cron Fail Alert

The Cron Fail Alert module monitors Drupal cron execution and sends email
alerts to site administrators when cron fails to run within a specified time
period. This helps prevent potential issues caused by stalled or failed cron
jobs, such as outdated search indexes, unprocessed queue items, or missed
scheduled tasks.

## Features

- **Configurable monitoring frequency**: Set how often to check if cron has
  failed
- **Customizable tolerance period**: Define the maximum time allowed before
  considering cron failed
- **Email notifications**: Receive alerts when cron failures are detected
- **Smart validation**: Built-in validation ensures tolerance is greater than
  check frequency to avoid false positives
- **Customizable messages**: Configure subject lines and message templates with
  token support
- **Organized settings**: Intuitive configuration form with monitoring and
  notification sections

## Requirements

This module requires Drupal 10 or 11.

## Installation

1. Install and enable the module like any other Drupal module.
   See [Drupal documentation](https://www.drupal.org/docs/extending-drupal/installing-modules)
   for more information on installing Drupal modules.

2. After installation, navigate to
   `Configuration > System > Cron > Cron Fail Alert Settings`
   or visit `/admin/config/system/cron/cron-fail-alert` to configure the module.

## Configuration

### Monitoring Settings

- **Check frequency**: How often to check if cron has failed, in minutes (
  default: 15).
  This prevents excessive checking on every page load. Range: 1-1440 minutes.

- **Cron failure tolerance**: Maximum time allowed since the last successful
  cron
  run before considering it failed, in minutes (default: 20). This should be
  greater than your site's cron frequency. For example, if your cron runs every
  15 minutes, set this to 20 or higher. Range: 1-10080 minutes (1 week).

### Email Notification Settings

- **Recipient email address**: Email address to receive cron failure
  notifications.
  Defaults to the site's default email address if not specified.

- **Email subject**: Subject line for the failure notification email. The site
  name will be automatically appended.

- **Email message**: Body of the failure notification email. Available tokens:
    - `@minutes`: Minutes since last cron run
    - `:site`: Site URL

## Usage

After installation and configuration, the module will automatically monitor cron
execution. If cron has not run within the specified tolerance period, an email
notification will be sent to the configured email address.

The module performs checks at the configured frequency to avoid performance
impact from constant monitoring.

## Contributing

Contributions are welcome! Please report issues or submit merge requests on the
module's [issue queue](https://www.drupal.org/project/issues/cron_fail_alert).

## License

This module is licensed under
the [GNU General Public License](https://www.gnu.org/licenses/gpl-2.0.html).
