<?php

declare(strict_types=1);

namespace Drupal\cron_fail_alert\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Mail\MailFormatHelper;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Hook implementations for Cron Fail Alert module.
 */
class CronFailAlertHooks {

  /**
   * Implements hook_mail().
   */
  #[Hook('mail')]
  public function mail(string $key, array &$message, array $params): void {
    // Set the options including the language code.
    $options = ['langcode' => $message['langcode']];

    // Check if the email key is 'cron_fail_alert_mail'.
    if ($key === 'cron_fail_alert_mail') {
      // Set the 'from' email address and subject using translated title.
      $message['from'] = \Drupal::config('system.site')->get('mail');
      $message['subject'] = new TranslatableMarkup('@title', ['@title' => $params['title']], $options);

      // Wrap and add the message body using MailFormatHelper.
      $message['body'][] = MailFormatHelper::wrapMail($params['message']);
    }
  }

}
