<?php

declare(strict_types=1);

namespace Drupal\crowdsec\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Event for building the scenario list.
 */
class ScenarioList extends Event {

  /**
   * Constructs the scenario list event.
   */
  public function __construct(
    protected array &$scenarios,
  ) {}

  /**
   * Get the list of scenarios.
   *
   * @return array
   *   The list of scenarios.
   */
  public function &getScenarios(): array {
    return $this->scenarios;
  }

}
