<?php

declare(strict_types=1);

namespace Drupal\crowdsec\Plugin\CrowdsecScenario;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\crowdsec\Attribute\Scenario;
use Drupal\crowdsec\ScenarioPluginBase;

/**
 * Plugin implementation of the flood scenario.
 */
#[Scenario(
  id: 'flood',
  scenario: 'drupal/auth-bruteforce',
  label: new TranslatableMarkup('Bans from flood control'),
  description: new TranslatableMarkup('Collects IPs that triggered flood control alerts.'),
  buffer: FALSE,
)]
final class Flood extends ScenarioPluginBase {

}
