<?php

declare(strict_types=1);

namespace Drupal\crowdsec\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Abstract class for IP address events.
 */
abstract class IpBaseEvent extends Event {

  /**
   * Constructs the IP address event.
   */
  public function __construct(
    protected string $ip,
  ) {}

  /**
   * Returns the IO address.
   *
   * @return string
   *   The IP address.
   */
  public function getIp(): string {
    return $this->ip;
  }

}
