<?php

declare(strict_types=1);

namespace Drupal\crowdsec;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for scenario plugins.
 */
interface ScenarioInterface extends PluginInspectionInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Adds a signal to the buffer to later send it to the API.
   *
   * @param string $ip
   *   The IPv4 address to be signalled.
   * @param int $status
   *   The response status for the current request.
   * @param string|null $targetUser
   *   The target user in case of a brute force attack.
   */
  public function addSignal(string $ip, int $status, ?string $targetUser = NULL): void;

  /**
   * Get a plugin related setting.
   *
   * @param string $key
   *   The setting key which can be one of 'enable', 'leak_speed',
   *   'bucket_capacity', 'ban_duration'.
   *
   * @return mixed
   *   The setting value.
   */
  public function getSetting(string $key): mixed;

  /**
   * Get the plugin related setting key.
   *
   * @param string $key
   *   The sub-key.
   *
   * @return string
   *   The setting key.
   */
  public function getSettingKey(string $key): string;

  /**
   * Get the storage key for an IP address.
   *
   * @param string $ip
   *   The IPv4 address.
   * @param string $key
   *   The sub-key.
   *
   * @return string
   *   The storage key.
   */
  public function getStorageKey(string $ip, string $key): string;

}
