<?php

declare(strict_types=1);

namespace Drupal\crowdsec\Event;

/**
 * Event for a signalled IP address.
 */
class IpSignalled extends IpBaseEvent {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    protected string $ip,
    protected string $scenario,
  ) {
    parent::__construct($ip);
  }

  /**
   * Returns the scenario.
   *
   * @return string
   *   The scenario.
   */
  public function getScenario(): string {
    return $this->scenario;
  }

}
