<?php

declare(strict_types=1);

namespace Drupal\crowdsec\Plugin\CrowdsecScenario;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\crowdsec\Attribute\Scenario;
use Drupal\crowdsec\ScenarioPluginBase;

/**
 * Plugin implementation of the whisper scenario.
 */
#[Scenario(
  id: 'whisper',
  scenario: 'drupal/4xx-scan',
  label: new TranslatableMarkup('Bans from whispers'),
  description: new TranslatableMarkup('Automatically bans IPs that often send requests resulting in 4xx status codes.'),
)]
final class Whisper extends ScenarioPluginBase {

}
