<?php

declare(strict_types=1);

namespace Drupal\crowdsec;

use Drupal\Component\Plugin\FallbackPluginManagerInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\crowdsec\Attribute\Scenario;

/**
 * Scenario plugin manager.
 */
final class ScenarioPluginManager extends DefaultPluginManager implements FallbackPluginManagerInterface {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/CrowdsecScenario', $namespaces, $module_handler, ScenarioInterface::class, Scenario::class);
    $this->alterInfo('crowdsec_scenario_info');
    $this->setCacheBackend($cache_backend, 'crowdsec_scenario_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function createInstance($plugin_id, array $configuration = []): ScenarioInterface {
    /** @var \Drupal\crowdsec\ScenarioInterface $plugin */
    $plugin = parent::createInstance($plugin_id, $configuration);
    return $plugin;
  }

  /**
   * {@inheritdoc}
   */
  public function getFallbackPluginId($plugin_id, array $configuration = []): string {
    return 'whisper';
  }

  /**
   * Instantiate and return a scenario plugin.
   *
   * @param string $id
   *   The plugin ID.
   */
  public static function getPlugin(string $id): ScenarioInterface {
    return \Drupal::service('plugin.manager.crowdsec_scenario')->createInstance($id);
  }

}
