# Crux – The AI Mention Bot

Crux lets site users summon an AI assistant simply by @ mentioning a designated bot user inside CKEditor (content or comments). When mentioned, Crux queues a background task that generates a contextual AI reply and (for threaded comment fields) posts it as a child reply, automatically @ mentioning the original commenter inline.

## Key Features
- **@ Mention Trigger**: The first time the bot user is mentioned in a given rich‑text field instance, an event fires (via `ckeditor_mentions`).
- **Queued Processing**: A queue item (`crux_mentions_response`) is created to avoid blocking the user’s request and to allow throttling / batching.
- **Context-Rich Replies**:
  - Primary (parent) entity title + first 200 characters of its body (if available).
  - Up to 3 ancestor (parent) comments (oldest → newest) for conversation continuity (threaded comment fields only).
  - The current mention comment’s text body.
  - Prior bot (assistant) ancestor comments are marked with the `assistant` role; all others as `user`.
- **Inline Author Mention**: The original comment author is auto @ mentioned at the start of the AI reply (inserted inside the first `<p>` tag when possible) using the CKEditor Mention anchor structure.
- **Thread Awareness**: If the comment field is configured for threaded mode, the AI response is saved as a child (`pid`) of the original comment.
- **Rate Limits & Throttling**: Per‑user daily mention limit, global daily mention limit, and a configurable delay before generating a reply.
- **Extensible Prompt**: A robust default system prompt governs behavior, tone, formatting, and safety.
- **Clean Uninstall (Optional)**: Can optionally delete all bot-authored content and the bot user upon uninstall.

## How It Works (Architecture Overview)
1. **User Mentions Bot**: In a CKEditor-enabled field supporting mentions, the user types `@<bot name>` and selects the bot (a Drupal user account) from the mention list.
2. **Event Subscriber**: `CruxMentionSubscriber` listens to `CKEditorEvents::MENTION_FIRST` and checks:
   - That the mentioned entity is the configured bot user.
   - Rate limits (per-user and global) have not been exceeded.
   - An AI provider/model has been configured.
3. **Queue Item Creation**: A queue item with the source entity ID + a future `throttle_after` timestamp is added to the `crux_mentions_response` queue.
4. **Queue Worker (`CruxMentionsResponse`)** runs (cron / queue runner):
   - Respects the throttle timestamp.
   - Loads the comment and its parent entity (e.g., a node) for context.
   - Detects if the comment field uses threaded mode.
   - Collects up to 3 ancestor comments (if threaded). Marks bot-authored ancestors as `assistant` messages.
   - Builds a structured `ChatInput` (previous thread messages + final context block containing primary entity info + mention content).
   - Calls the configured AI provider/model via the `ai` module.
   - Converts AI markdown output to HTML (CommonMark) and injects an inline CKEditor mention anchor for the original author.
   - Creates a new comment (child if threaded) authored by the bot user.
5. **User Sees Reply**: The AI reply appears in the thread, with the original commenter @ mentioned.

## Configuration
Navigate to: `Admin > Configuration > AI > Crux settings` (`/admin/config/ai/crux`)

| Setting | Description |
|---------|-------------|
| Bot User (implicit `bot_uid`)* | Numeric user ID for the bot (must exist and be mentionable). (*Configured outside the current form—see Bot User section below.) |
| User daily mention limit (`user_daily_mention_limit`) | Max mentions per content author per day (0 = unlimited). |
| Global daily limit (`global_daily_limit`) | Max total bot responses site‑wide per day (0 = unlimited). |
| Throttle response time (`throttle_response_time`) | Minutes to wait after mention before processing (helps batch edits). |
| AI Provider (`ai_provider_id`) | Selected AI integration plugin (from `ai` module). |
| AI Model (`ai_model_id`) | Specific model ID for the provider. |
| Provider configuration (`ai_provider_configuration`) | Dynamic, provider-specific settings auto-managed by the form helper. |
| Delete on uninstall (`delete_on_uninstall`) | If checked, removes bot user plus bot-authored nodes & comments when uninstalling. |
| Default system prompt (`default_system_prompt`) | Governs baseline behavior, formatting, and safety for AI replies. |

### Bot User
Create a dedicated Drupal user (e.g., “Crux Bot”) and record its UID. Currently the settings form expects `bot_uid` to be managed elsewhere (via install hook or manual config edit). To set manually:

```bash
# Replace 5 with the bot user’s actual uid.
ddev drush cset crux.settings bot_uid 5 -y
```

Ensure the bot user:
- Has permission to post comments on relevant content types.
- Is enabled and visible in mention results (depends on how CKEditor mentions is configured).

### Adjusting the System Prompt
You can edit the System Prompt under the “Default AI system prompt” fieldset. If you need environment‑specific variations, consider exporting config and using a config split or per‑environment overrides.

### Changing Limits Mid-Day
Counters are stored in Drupal `state` under `crux.daily_counts` (reset daily). Changing limits affects subsequent mentions immediately; already-queued items still process unless throttled out-of-window.

## Mention Format
Crux relies on the structure produced by `ckeditor_mentions`. A typical mention anchor looks like:

```html
<a class="mention" data-mention="@2" data-entity-type="user" data-entity-uuid="USER-UUID" data-plugin="user" href="/user/2">@crux</a>
```

Crux automatically injects a similar anchor (for the original comment’s author) at the start of its AI reply.

## Queue Processing
Run manually:

```bash
ddev drush queue-run crux_mentions_response
```

Cron will normally process the queue. If you rely solely on Drupal’s core cron, ensure it runs frequently enough relative to the throttle window.

