<?php

namespace Drupal\crux\Event;

use Drupal\Core\Entity\EntityInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event fired when the global daily Crux mention limit is exceeded.
 */
class CruxGlobalDailyLimitExceededEvent extends Event {

  public function __construct(
    protected int $limit,
    protected int $count,
    protected ?EntityInterface $sourceEntity = NULL,
  ) {}

  /**
   * The configured global limit.
   */
  public function getLimit(): int {
    return $this->limit;
  }

  /**
   * The current processed/queued count when exceeded.
   */
  public function getCount(): int {
    return $this->count;
  }

  /**
   * The entity where the exceeding mention occurred, if available.
   */
  public function getSourceEntity(): ?EntityInterface {
    return $this->sourceEntity;
  }

}

