<?php

namespace Drupal\crux\Event;

use Drupal\Core\Entity\EntityInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event fired when a user's daily Crux mention limit is exceeded.
 */
class CruxUserDailyMentionLimitExceededEvent extends Event {

  public function __construct(
    protected int $userId,
    protected int $limit,
    protected int $count,
    protected ?EntityInterface $sourceEntity = NULL,
  ) {}

  /**
   * The user ID whose limit was exceeded.
   */
  public function getUserId(): int {
    return $this->userId;
  }

  /**
   * The configured per-user limit.
   */
  public function getLimit(): int {
    return $this->limit;
  }

  /**
   * The count at the time of exceeding the limit.
   */
  public function getCount(): int {
    return $this->count;
  }

  /**
   * The entity involved in the mention (node/comment etc.), if available.
   */
  public function getSourceEntity(): ?EntityInterface {
    return $this->sourceEntity;
  }

}
