<?php

namespace Drupal\css_class_collector\Service;

class ClassExtractor {

  /**
   * Extract CSS classes from HTML markup.
   */
  public function extractClasses(string $html): array {
    $classes = [];

    if (preg_match_all('/class="([^"]+)"/i', $html, $matches)) {
      foreach ($matches[1] as $group) {
        foreach (explode(' ', $group) as $class) {
          $class = trim($class);
          if ($class !== '') {
            $classes[] = $class;
          }
        }
      }
    }
    return array_unique($classes);
  }
}
