<?php

namespace Drupal\css_class_collector\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Batch\BatchBuilder;

/**
 * Start a batch to scan all classes.
 */
class BatchRunController extends ControllerBase {

  /**
   * Simple page with button to start batch.
   */
  public function scanPage() {
    return [
      '#type' => 'link',
      '#title' => $this->t('Run Full Scan'),
      '#url' => \Drupal\Core\Url::fromRoute('css_class_collector.batch_start'),
      '#attributes' => ['class' => ['button', 'button--primary']],
    ];
  }

  /**
   * Builds and launches batch.
   */
  public function startBatch() {

    $builder = new BatchBuilder();
    $builder->setTitle($this->t('Scanning all CSS classes'))
      ->setInitMessage($this->t('Starting class extraction...'))
      ->setProgressMessage($this->t('Processed @current of @total...'))
      ->setErrorMessage($this->t('An error occurred during class scanning.'));

    // -----------------------------------------------------------
    // FIX APPLIED: entityQuery now defines ->accessCheck(FALSE)
    // -----------------------------------------------------------

    $node_ids = \Drupal::entityQuery('node')
      ->accessCheck(FALSE)
      ->execute();

    $paragraph_ids = \Drupal::entityQuery('paragraph')
      ->accessCheck(FALSE)
      ->execute();

    $block_ids = \Drupal::entityQuery('block_content')
      ->accessCheck(FALSE)
      ->execute();

    // Add batch operations.
    foreach ($node_ids as $nid) {
      $builder->addOperation(
        ['\Drupal\css_class_collector\Batch\Scanner', 'processNode'],
        [$nid]
      );
    }

    foreach ($paragraph_ids as $pid) {
      $builder->addOperation(
        ['\Drupal\css_class_collector\Batch\Scanner', 'processParagraph'],
        [$pid]
      );
    }

    foreach ($block_ids as $bid) {
      $builder->addOperation(
        ['\Drupal\css_class_collector\Batch\Scanner', 'processBlock'],
        [$bid]
      );
    }

    // Scan views last.
    $builder->addOperation(
      ['\Drupal\css_class_collector\Batch\Scanner', 'processViews'],
      []
    );

    // Finished callback.
    $builder->setFinishCallback(
      ['\Drupal\css_class_collector\Batch\Scanner', 'finishBatch']
    );

    batch_set($builder->toArray());
    return batch_process('/admin/reports/css-classes');
  }

}
