<?php

namespace Drupal\css_class_collector\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Database\Database;
use Symfony\Component\HttpFoundation\Response;

class ClassListController extends ControllerBase {

  /**
   * List all collected CSS classes + export button.
   */
  public function list() {
    $rows = [];
    $results = Database::getConnection()
      ->select('css_class_collector')
      ->fields('css_class_collector', ['class_name'])
      ->orderBy('class_name')
      ->execute();

    foreach ($results as $record) {
      $rows[] = [$record->class_name];
    }

    return [
      'export_button' => [
        '#type' => 'link',
        '#title' => $this->t('Export CSV'),
        '#url' => \Drupal\Core\Url::fromRoute('css_class_collector.export'),
        '#attributes' => ['class' => ['button', 'button--primary'], 'style' => 'margin-bottom:15px;'],
      ],
      'table' => [
        '#type' => 'table',
        '#header' => ['CSS Class'],
        '#rows' => $rows,
      ],
    ];
  }

  /**
   * Export all CSS classes as a CSV download.
   */
  public function export() {
    $connection = Database::getConnection();
    $query = $connection->select('css_class_collector')
      ->fields('css_class_collector', ['class_name'])
      ->orderBy('class_name');

    $records = $query->execute()->fetchAll();

    $csv = "class_name\n";
    foreach ($records as $record) {
      $csv .= $record->class_name . "\n";
    }

    $response = new Response($csv);
    $response->headers->set('Content-Type', 'text/csv');
    $response->headers->set('Content-Disposition', 'attachment; filename="css-classes.csv"');

    return $response;
  }

}
