# CSS Variables customizer

Allows overriding CSS variables of your site theme without needing to deploy.

This is pretty useful for sites that need minimal changes over a base theme, being able to adjust the theming without being blocked by deployment processes.

It allows to doing it by just wrapping your css variables into annotations.

## Features

-   Override of variables of the main css files of your theme.
-   Override of variables of the SDCs.
-   Auto discover of CSS variables through CSS comment annotations.
-   Preview of changes before saving customizations.
-   Support for multiple themes.

## Post-Installation

After installing it, it is needed to setup your theme to support customizations.

First, it is needed to declare in the .info.yml file of your theme the source files of the main CSS:

```yaml
css_variables_customizer:
  stylesheets:
    - cssSourceFolder
    - src/cssSpecificFile.css
```

At stylesheets, it is possible adding folders

To let the variables be discovered, it is needed to wrap those variables into these annotations:

1.   Beginning: **@css-variables-customizer-category category** . Replace category with any name, it will be displayed in UI.
2.   End: **@css-variables-customizer-category-end** . Add this after the last variable you want override.

Example:

```css
/* @css-variables-customizer-category theme */
  --card-media-aspect: 16/9;
  --card-radius: var(--theme-radius, 0.5rem);
  --card-spacing: var(--theme-spacing, 0.25rem);
  /* @css-variables-customizer-category-end */
```

After this, clear caches and go to /admin/appearance/css-variables-customizer. Your theme will appear in the list and you can select it and override the variables.

## Recommended modules/libraries

It is highly recommended to use the [SDC Styleguide](https://www.drupal.org/project/sdc_styleguide) module to preview the components overrides.

## Similar projects

[UI skins](https://www.drupal.org/project/ui_skins "UI skins") allows to declare variables in a yaml file and then override them.
