<?php

namespace Drupal\css_variables_customizer\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\AdminContext;
use Drupal\Core\Theme\ThemeManagerInterface;
use Drupal\css_variables_customizer\CssVariablesManagerInterface;

/**
 * Attach assets at the page top.
 */
class AttachmentHooks {

  /**
   * Constructs the hook.
   *
   * @param \Drupal\Core\Theme\ThemeManagerInterface $themeManager
   *   Used to get the active theme.
   * @param \Drupal\css_variables_customizer\CssVariablesManagerInterface $cssVariablesManager
   *   Used to build the render array with the theme customizations.
   * @param \Drupal\Core\Routing\AdminContext $adminContext
   *   Used to check if we are in an.admin route.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   Configuration factory.
   */
  public function __construct(
    protected ThemeManagerInterface $themeManager,
    protected CssVariablesManagerInterface $cssVariablesManager,
    protected AdminContext $adminContext,
    protected ConfigFactoryInterface $configFactory,
  ) {
  }

  /**
   * Add theme customizations to the page top.
   */
  #[Hook('page_top')]
  public function attachCustomizations(array &$page_top) {
    $theme = $this->themeManager->getActiveTheme()->getName();
    $page_top += $this->cssVariablesManager->buildThemeCustomizations($theme);

    if ($this->adminContext->isAdminRoute()) {
      $theme = $this->configFactory->get('system.theme')->get('default');
      $page_top += $this->cssVariablesManager->buildThemeCustomizations($theme, '.ck-content');
    }
  }

}
