<?php

namespace Drupal\css_variables_customizer\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Provides help information for the CSS Variables Customizer module.
 */
class CssVariablesCustomizerHelp {

  use StringTranslationTrait;

  /**
   * Provides help for the CSS Variables Customizer module.
   *
   * @param string $route_name
   *   The route name.
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   *
   * @return string|null
   *   The help text.
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.css_variables_customizer':
        $output = '';
        $output .= '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('Allow override css variables of your themes. To know how to use it, please refer to the instructions explained at <a href=":url">https://www.drupal.org/project/css_variables_customizer</a>', [':url' => 'https://www.drupal.org/project/css_variables_customizer']) . '</p>';
        return $output;
    }
    return NULL;
  }

}
