<?php

namespace Drupal\css_variables_customizer\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Extension\ThemeExtensionList;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\css_variables_customizer\ThemeFinderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides task link definitions for CSS variables customizer themes.
 */
class TaskLinkDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * The theme finder service.
   *
   * @var \Drupal\css_variables_customizer\ThemeFinderInterface
   */
  protected ThemeFinderInterface $themeFinder;

  /**
   * The theme extension list.
   *
   * @var \Drupal\Core\Extension\ThemeExtensionList
   */
  protected ThemeExtensionList $themeExtensionList;

  /**
   * Constructs a new TaskLinkDeriver.
   *
   * @param \Drupal\css_variables_customizer\ThemeFinderInterface $themeFinder
   *   The theme finder service.
   * @param \Drupal\Core\Extension\ThemeExtensionList $themeExtensionList
   *   The theme extension list.
   */
  public function __construct(ThemeFinderInterface $themeFinder, ThemeExtensionList $themeExtensionList) {
    $this->themeFinder = $themeFinder;
    $this->themeExtensionList = $themeExtensionList;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('css_variables_customizer.theme_finder'),
      $container->get('extension.list.theme')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $themes = $this->themeFinder->findCustomizableThemes();

    foreach ($themes as $theme) {
      $themeInfo = $this->themeExtensionList->get($theme);
      $themeName = $themeInfo->info['name'] ?? ucfirst($theme);

      $this->derivatives[$theme] = $base_plugin_definition;
      $this->derivatives[$theme]['title'] = $themeName;
      $this->derivatives[$theme]['route_name'] = 'css_variables_customizer.theme.' . $theme;
      $this->derivatives[$theme]['parent_id'] = 'css_variables_customizer.overview';
      $this->derivatives[$theme]['base_route'] = 'css_variables_customizer.overview';
      $this->derivatives[$theme]['weight'] = 10;
    }

    return $this->derivatives;
  }

}
