<?php

namespace Drupal\css_variables_customizer;

use Drupal\Core\Extension\ThemeExtensionList;

/**
 * Finds the list of themes that supports customizer.
 */
class ThemeFinder implements ThemeFinderInterface {

  /**
   * Constructs the finder.
   *
   * @param \Drupal\Core\Extension\ThemeExtensionList $themeExtensionList
   *   Used to get the theme list.
   */
  public function __construct(protected ThemeExtensionList $themeExtensionList) {}

  /**
   * {@inheritdoc}
   */
  public function findCustomizableThemes() : array {
    return array_keys(array_filter($this->themeExtensionList->getList(), function ($theme) {
      return (bool) $theme->status && isset($theme->info['css_variables_customizer']);
    }));
  }

}
