(function (Drupal, once) {
  Drupal.behaviors.cssVariablesCustomizerAutoPreview = {};

  Drupal.behaviors.cssVariablesCustomizerAutoPreview.attach = function (
    context,
    settings,
  ) {
    once(
      'css-customizer-auto-preview',
      '.css-variables-customizer-override-value',
      context,
    ).forEach(function (input) {
      input.addEventListener('focusout', function (e) {
        const inputName = e.target.name;

        const match = inputName.match(/^customizations\[([^\]]+)\]/);

        if (match && match[1]) {
          const componentName = match[1];
          const buttonName = componentName.concat(':preview');

          const previewButton = document.querySelector(
            `input[type="submit"][name="${buttonName}"]`,
          );

          if (previewButton) {
            const mouseDownEvent = new MouseEvent('mousedown');
            previewButton.dispatchEvent(mouseDownEvent);
          }
        }
      });
    });
  };
})(Drupal, once);
