<?php

namespace Drupal\css_variables_customizer\Cache\Context;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Cache\Context\CacheContextInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\TempStore\PrivateTempStoreFactory;

/**
 * Cache context for CSS variables preview data.
 */
class CssVariablesPreviewCacheContext implements CacheContextInterface {

  /**
   * The current user account.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected AccountInterface $currentUser;

  /**
   * The private tempstore factory.
   *
   * @var \Drupal\Core\TempStore\PrivateTempStoreFactory
   */
  protected PrivateTempStoreFactory $tempStoreFactory;

  /**
   * Constructs a CssVariablesPreviewCacheContext object.
   *
   * @param \Drupal\Core\Session\AccountInterface $current_user
   *   The current user account.
   * @param \Drupal\Core\TempStore\PrivateTempStoreFactory $temp_store_factory
   *   The private tempstore factory.
   */
  public function __construct(AccountInterface $current_user, PrivateTempStoreFactory $temp_store_factory) {
    $this->currentUser = $current_user;
    $this->tempStoreFactory = $temp_store_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function getLabel() {
    return t('CSS Variables Preview');
  }

  /**
   * {@inheritdoc}
   */
  public function getContext($parameter = NULL) {
    if (!$parameter) {
      return 'no-theme';
    }

    $temp_store = $this->tempStoreFactory->get('css_variables_customizer');
    $preview_data = $temp_store->get('preview_' . $parameter);

    if (empty($preview_data)) {
      return 'no-preview';
    }

    // Return a hash of the preview data to use as cache context.
    return hash('sha256', serialize($preview_data));
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheableMetadata($parameter = NULL) {
    return new CacheableMetadata();
  }

}
