<?php

namespace Drupal\css_variables_customizer\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Extension\ThemeExtensionList;
use Drupal\Core\Url;
use Drupal\css_variables_customizer\ThemeFinderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Show links to access customizer forms.
 */
class OverviewController extends ControllerBase {

  /**
   * Finds the themes that supports css customizer variables.
   *
   * @var \Drupal\css_variables_customizer\ThemeFinderInterface
   */
  protected ThemeFinderInterface $themeFinder;

  /**
   * Gets the theme name to display links.
   *
   * @var \Drupal\Core\Extension\ThemeExtensionList
   */
  protected ThemeExtensionList $themeExtensionList;

  public function __construct(ThemeFinderInterface $themeFinder, ThemeExtensionList $themeExtensionList) {
    $this->themeFinder = $themeFinder;
    $this->themeExtensionList = $themeExtensionList;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('css_variables_customizer.theme_finder'),
      $container->get('extension.list.theme')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function overview() {
    $themes = $this->themeFinder->findCustomizableThemes();

    if (empty($themes)) {
      return [
        '#markup' => $this->t('No themes support CSS variables customization.'),
      ];
    }

    $content = [];
    foreach ($themes as $theme) {
      $themeInfo = $this->themeExtensionList->get($theme);
      $themeName = $themeInfo->info['name'] ?? ucfirst($theme);

      $content[] = [
        'title' => $themeName,
        'url' => Url::fromRoute('css_variables_customizer.theme.' . $theme),
        'description' => $this->t('Customize CSS variables for @theme theme', ['@theme' => $themeName]),
        'options' => [],
      ];
    }

    return [
      '#theme' => 'admin_block_content',
      '#content' => $content,
    ];
  }

}
