<?php

namespace Drupal\css_variables_customizer\Routing;

use Drupal\Core\Extension\ThemeExtensionList;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\css_variables_customizer\Form\CustomizerForm;
use Drupal\css_variables_customizer\ThemeFinderInterface;
use Symfony\Component\Routing\RouteCollection;
use Symfony\Component\Routing\Route;

/**
 * Adds forms for themes using CSS customizer.
 */
class RouteSubscriber extends RouteSubscriberBase {

  use StringTranslationTrait;

  /**
   * The theme finder service.
   *
   * @var \Drupal\css_variables_customizer\ThemeFinderInterface
   */
  protected ThemeFinderInterface $themeFinder;

  /**
   * The theme extension list.
   *
   * @var \Drupal\Core\Extension\ThemeExtensionList
   */
  protected ThemeExtensionList $themeExtensionList;

  /**
   * Constructs a RouteSubscriber object.
   *
   * @param \Drupal\css_variables_customizer\ThemeFinderInterface $themeFinder
   *   The theme finder service.
   * @param \Drupal\Core\Extension\ThemeExtensionList $themeExtensionList
   *   The theme extension list.
   */
  public function __construct(ThemeFinderInterface $themeFinder, ThemeExtensionList $themeExtensionList) {
    $this->themeFinder = $themeFinder;
    $this->themeExtensionList = $themeExtensionList;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    $themes = $this->themeFinder->findCustomizableThemes();

    foreach ($themes as $theme) {
      $themeInfo = $this->themeExtensionList->get($theme);
      $themeName = $themeInfo->info['name'] ?? ucfirst($theme);

      $route = new Route(
        '/admin/appearance/css-variables-customizer/' . $theme,
        [
          '_form' => CustomizerForm::class,
          '_title' => 'Css variables customizations for ' . $themeName,
          'theme' => $theme,
        ],
        [
          '_permission' => 'administer themes',
        ]
      );

      $collection->add('css_variables_customizer.theme.' . $theme, $route);
    }
  }

}
