(function ($, Drupal, once) {
  Drupal.behaviors.csvDatatables = {
    attach: function attach(context, settings) {
      $(once('csv-table-processed', "div.csv-table", context)).each(function () {
        var link = this.querySelector("a");
        if (!link) {
          return;
        }

        var div = this;
        var tableSettings = JSON.parse(div.dataset.settings || "{}");

        // Disable stateSave explicitly
        tableSettings.stateSave = false;

        if (tableSettings.centerContent) {
          div.classList.add("center-content");
        }

        var autolink = false;
        if (tableSettings.autolink && typeof Autolinker !== "undefined") {
          autolink = new Autolinker({
            newWindow: Boolean(tableSettings.autolinkNewWindow),
            stripPrefix: false,
            truncate: 50,
          });
        }

        var urlColumnNumber = tableSettings.urlColumnNumber
          ? tableSettings.urlColumnNumber - 1
          : null;

        // Ensure DataTables is available before initializing
        if (typeof $.fn.DataTable === "undefined") {
          console.error("🚨 DataTables library is missing. Make sure it is loaded before this script.");
          return;
        }

        const renderTable = (parsed) => {
          var table = document.createElement("table");
          div.classList.remove("csv-table");

          if (tableSettings.download) {
            div.insertBefore(table, div.childNodes[0]);
          } else {
            div.innerHTML = "";
            div.insertBefore(table, div.childNodes[0]);
          }

          div.classList.remove("hidden");
          table.className = div.className;
          table.setAttribute("style", "width: 100%");

          if (div.classList.contains("dataTable")) {
            tableSettings.columns = [];
            var headerData = parsed.data.shift();
            tableSettings.data = parsed.data;

            if (tableSettings.data.length > 100) {
              tableSettings.deferRender = true;
            }

            tableSettings.data = parsed.data;

            for (var i = 0; i < headerData.length; i++) {
              tableSettings.columns.push({ title: headerData[i] });
            }

            // Create links in table
            if (autolink) {
              if (tableSettings.urlColumnNumber) {
                tableSettings.data = tableSettings.data.map(function (row) {
                  if (row[0] === "") {
                    urlColumnNumber = tableSettings.urlColumnNumber || null;
                  }
                  if (urlColumnNumber && row[urlColumnNumber - 1] && row[urlColumnNumber]) {
                    row[urlColumnNumber] = Autolinker.link(row[urlColumnNumber], {
                      newWindow: Boolean(tableSettings.autolinkNewWindow),
                      replaceFn: function (match) {
                        var tag = match.buildTag();
                        tag.setInnerHtml(row[urlColumnNumber - 1]);
                        return tag;
                      },
                    });
                  }
                  row.splice(urlColumnNumber - 1, 1);
                  return row;
                });
                tableSettings.columns[urlColumnNumber].title = tableSettings.columns[urlColumnNumber - 1].title;
                tableSettings.columns.splice(urlColumnNumber - 1, 1);
              }
            }

            // Enable ScrollX for proper scrolling
            tableSettings.scrollX = true;
            tableSettings.autoWidth = true;

            // Dynamically set FixedHeader and FixedColumns based on widget settings
            tableSettings.fixedHeader = !!tableSettings.freezeRowHeaders;

            if (tableSettings.freezeColumnHeaders) {
              tableSettings.fixedColumns = {
                left: 1, // Freeze first column
              };
            } else {
              tableSettings.fixedColumns = false;
            }

            let dtable;

            if (typeof tableSettings.hideSearchingData !== "undefined" && typeof tableSettings.searching !== "undefined") {
              if (tableSettings.hideSearchingData === 1 && tableSettings.searching === 1) {
                dtable = $(table).DataTable({
                  ...tableSettings,
                  search: {
                    return: true,
                  },
                  language: {
                    search: tableSettings.searchLabel ? tableSettings.searchLabel + ":" : "Search:",
                  },
                  layout: {
                    topStart: "search",
                    topEnd: ""
                  }
                });

                dtable.search("").draw();

                var $dtLayoutElements = dtable.tables().containers().to$()
                  .find("div.dt-layout-table")
                  .add("div.dt-info")
                  .add("div.dt-paging");
                $dtLayoutElements.hide();

                var $search = $(table).parent().find('input[type="search"]');
                var $button = $('<button type="submit" class="dt-search-submit">Search</button>')
                  .insertAfter($search);

                dtable.on("search.dt", function () {
                  var searchTerm = dtable.search();
                  if (searchTerm) {
                    $dtLayoutElements.show();
                  } else {
                    $dtLayoutElements.hide();
                  }
                });

                $button.on("click", function () {
                  var searchTerm = $search.val();
                  dtable.search(searchTerm).draw();
                });
              } else {
                dtable = $(table).DataTable(tableSettings);
              }
            } else {
              dtable = $(table).DataTable(tableSettings);
            }

            var className = "dt-search-right-aligned";
            if (typeof tableSettings.lengthChange !== "undefined" && typeof tableSettings.searching !== "undefined") {
              if (tableSettings.lengthChange === 0 && tableSettings.searching === 1) {
                className = "dt-search-left-aligned";
              }
            }
            $(table).parent().addClass(className);
          }
        };

        Papa.parse(link.href, {
          download: true,
          skipEmptyLines: true,
          transform: function (value, colNumber) {
            if (autolink && colNumber !== urlColumnNumber) {
              value = autolink.link(value);
            }
            return value;
          },
          complete: (parsed) => renderTable(parsed),
        });
      });
    },
  };
})(jQuery, Drupal, once);
