# CSV Importer

The module provides a powerful and flexible solution for importing data from CSV files into Drupal. Designed to handle various use cases, this module allows administrators to map CSV columns to entity fields seamlessly, enabling the bulk creation or updating of content, users, or other entities. With support for large datasets, module simplifies data migration and ensures efficient integration with your Drupal site.

## Table of contents

- Requirements
- Installation
- Usage
- Features
- Sponsors
- Maintainers

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Usage

1. Navigate to Administration > Content > Import CSV -
   _/admin/content/csv-importer_
1. Select entity type, entity bundle, delimiter
1. Make sure that the file is in the UTF-8 format
1. Select the file
1. Press "Import"

## Features

- [Import content](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/csv-importer/import-content)
- [Import content for multiple field](https://www.drupal.org/docs/8/modules/csv-importer/import-multiple-content)

For more details and examples see
[documentation](https://www.drupal.org/docs/contributed-modules/csv-importer).

## Sponsors

[YOUCANIC](https://www.youcanic.com)

## Maintainers

Lasha Badashvili - [lashabp](https://www.drupal.org/u/lashabp)
