<?php

namespace Drupal\currency\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Provides an event to resolve the current country code.
 *
 * @see \Drupal\currency\Event\CurrencyEvents::RESOLVE_COUNTRY_CODE
 */
class ResolveCountryCode extends Event {

  /**
   * The country code.
   *
   * @var string
   */
  protected $countryCode;

  /**
   * Sets the country code.
   *
   * @param string $country_code
   *   The country code.
   *
   * @return $this
   *   The current event, for chaining.
   */
  public function setCountryCode($country_code) {
    // We only want to stop propagation if an actual value was set. Setting an
    // empty value is allowed, but should not have consequences for event
    // propagation.
    if (!empty($country_code)) {
      $this->countryCode = $country_code;
      $this->stopPropagation();
    }

    return $this;
  }

  /**
   * Returns the country code.
   *
   * @return string
   *   The country code.
   */
  public function getCountryCode() {
    return $this->countryCode;
  }

}
